// emulEspaa. Added by MoNKi [MoNKi: -UPnPNAT Support-]

//File coded by MoNKi for the "emulEspaa Mod" based on a sample code by Bkausbk

#include "StdAfx.h"
#include "natupnp.h"
#include "UPnPNat.h"
//>>> WiZaRd::UPnP
#include "emule.h"
#include "Preferences.h"
#include "otherfunctions.h"
#include "Log.h"
#include "ini2.h"
//<<< WiZaRd::UPnP

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//>>> WiZaRd::UPnP
//////////////////////////////////////////////////////////////////////////
// DoUPnPPossibilityCheck function
// 
//Copyright (C)2006 WiZaRd ( thewizardofdos@gmail.com / http://kademlia-net.de )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//This does a quick check to see whether UPnP usage is possible or not
//Feel free to use it as you like, however you HAVE to mention me as the author
//and make your program OpenSource if you use this code or parts of it in 
//your own program!
//////////////////////////////////////////////////////////////////////////
/*
12/11/2006:	first version written for www.kademlia-net.de
	* includes detailed error messages
	* includes enumeration for debugging purposes
	* asks if the user wants to start the service if it's not running
	* asks if the user wants to change the service start type to on demand 
	  if it's disabled - lot's of "system tweak tools" disable this service as it's 
	  "possibly dangerous and not used by any hardware/program so far" - lol...
*/
//////////////////////////////////////////////////////////////////////////
//
//be careful here! GetLastError() != ::GetLastError() because the class implements
//its own version

#ifdef _DEBUG
CString _DbgServiceType(const DWORD& dw)
{
	switch(dw)
	{
		case SERVICE_FILE_SYSTEM_DRIVER:	return _T("The service is a file system driver."); 
		case SERVICE_KERNEL_DRIVER:			return _T("The service is a device driver."); 
		case SERVICE_WIN32_OWN_PROCESS:		return _T("The service runs in its own process.");
		case SERVICE_WIN32_SHARE_PROCESS:	return _T("The service shares a process with other services.");
		case SERVICE_INTERACTIVE_PROCESS:	return _T("The service can interact with the desktop.");
	}
	return _T("Unknown!");
}

CString _DbgServiceStatus(const DWORD& dw)
{
	switch(dw)
	{
		case SERVICE_STOPPED:			return _T("The service is not running.");
		case SERVICE_START_PENDING:		return _T("The service is starting."); 
		case SERVICE_STOP_PENDING:		return _T("The service is stopping."); 
		case SERVICE_RUNNING:			return _T("The service is running."); 
		case SERVICE_CONTINUE_PENDING:	return _T("The service continue is pending."); 
		case SERVICE_PAUSE_PENDING:		return _T("The service pause is pending."); 
		case SERVICE_PAUSED:			return _T("The service is paused."); 
	}
	return _T("Unknown!");
}
#endif

CString _DbgServiceError(const DWORD& dw)
{
	switch(dw)	
	{
		case ERROR_ACCESS_DENIED:			return _T("The handle does not have sufficient access rights."); 
		case ERROR_MORE_DATA:				return _T("The buffer is too small. More data is available.");
		case ERROR_INVALID_PARAMETER:		return _T("A parameter that was specified is invalid."); 
		case ERROR_INVALID_HANDLE:			return _T("The specified handle is invalid."); 
		case ERROR_INVALID_LEVEL:			return _T("The InfoLevel parameter contains an unsupported value.");
		case ERROR_SHUTDOWN_IN_PROGRESS:	return _T("The system is shutting down; this function cannot be called."); 
		case ERROR_INVALID_NAME:			return _T("The specified service name is invalid."); 
		case ERROR_SERVICE_DOES_NOT_EXIST:	return _T("The specified service does not exist.");
		case ERROR_INSUFFICIENT_BUFFER:		return _T("The buffer is too small."); 
		case ERROR_CIRCULAR_DEPENDENCY:			return _T("A circular service dependency was specified."); 
		case ERROR_DUPLICATE_SERVICE_NAME:		return _T("The display name already exists in the service controller manager database, either as a service name or as another display name."); 		
		case ERROR_INVALID_SERVICE_ACCOUNT:		return _T("The account name does not exist, or a service is specified to share the same binary file as an already installed service but with an account name that is not the same as the installed service.");
		case ERROR_SERVICE_MARKED_FOR_DELETE:	return _T("The service has been marked for deletion.");
		case ERROR_PATH_NOT_FOUND:				return _T("The service binary file could not be found."); 
		case ERROR_SERVICE_ALREADY_RUNNING:		return _T("An instance of the service is already running."); 
		case ERROR_SERVICE_DATABASE_LOCKED:		return _T("The database is locked.");
		case ERROR_SERVICE_DEPENDENCY_DELETED:	return _T("The service depends on a service that does not exist or has been marked for deletion."); 
		case ERROR_SERVICE_DEPENDENCY_FAIL:		return _T("The service depends on another service that has failed to start."); 
		case ERROR_SERVICE_DISABLED:			return _T("The service has been disabled."); 
		case ERROR_SERVICE_LOGON_FAILED:		return _T("The service did not start due to a logon failure. This error occurs if the service is configured to run under an account that does not have the \"Log on as a service\" right."); 
		case ERROR_SERVICE_NO_THREAD:			return _T("A thread could not be created for the service.");
		case ERROR_SERVICE_REQUEST_TIMEOUT:		return _T("The process for the service was started, but it did not call StartServiceCtrlDispatcher, or the thread that called StartServiceCtrlDispatcher may be blocked in a control handler function."); 
	}
	return _T("Unknown!"); 
}

CString _DbgSystemService(const DWORD& dw)
{
	if(dw == SERVICE_RUNS_IN_SYSTEM_PROCESS)
		return _T("The service runs in a system process that must always be running.");
	return _T("-");
}

#define SERVICE_NAME _T("UPNPhost") //todo - what's the name of the upnp service?
#define SERVICE_STATE_UNDEFINED		0x05
void CUPnPNat::DoUPnPPossibilityCheck(bool bAllowMessageBox)
{
	//m_bUPnPPossible = false;
	CIni tmpini(thePrefs.GetConfigFile(), _T("EMF"));
	uint8 iSetting = (uint8)tmpini.GetInt(L"UPnPNat_StartService", 1); //0: off | 1: ask | 2: on
	if(iSetting == 0)
		bAllowMessageBox = false; //don't ask, will fail if it isn't running
	const bool bSkipMessageBoxes = iSetting == 2; //always agree to messageboxes
	CString strNotPossible = _T("unknown error");
	//Vista and Windows2003 should also fall below _WINVER_XP_
	if(thePrefs.GetWindowsVersion() == _WINVER_XP_)
	{
		// Open a handle to the SC Manager database. 
		SC_HANDLE schSCManager = OpenSCManager( 
			NULL,						// local machine 
			SERVICES_ACTIVE_DATABASE,	// ServicesActive database 
			SC_MANAGER_ENUMERATE_SERVICE);  

		if (schSCManager) 
		{
			theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: services database opened successfully!"));
			
#ifdef _DEBUG
			//////////////////////////////////////////////////////////////////////////
			//this enumerates the devices, should only be needed in debug builds
			//disable it for release builds to save RAM and a few CPU cycles :)
			DWORD dwNeededBytes = 0;
			DWORD dwFoundServiceCount = 0;
			//the first call is destined to fail and return the number of needed bytes to us
			EnumServicesStatusEx(schSCManager,	//service control manager
				SC_ENUM_PROCESS_INFO,			//info level
				SERVICE_DRIVER|SERVICE_WIN32,	//service type
				SERVICE_STATE_ALL,				//service state
				NULL,							//buffer for services
				0,								//size of that buffer
				&dwNeededBytes,					//returns the needed bytes
				&dwFoundServiceCount,			//returns the number of services enumerated
				NULL,							//resume handle
				NULL);							//group string - empty: only non-assigned, NULL: all
			if(::GetLastError() == ERROR_MORE_DATA)
			{
				LPDWORD pResumeHandle = NULL;
				theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: starting enum..."));
				do
				{
					const DWORD buffsize = dwNeededBytes;
					BYTE* pBuffer = new BYTE[buffsize];					
					if(EnumServicesStatusEx(schSCManager, SC_ENUM_PROCESS_INFO, SERVICE_DRIVER|SERVICE_WIN32, SERVICE_STATE_ALL, pBuffer, buffsize, &dwNeededBytes, &dwFoundServiceCount, pResumeHandle, NULL))
					{
						//output more details about the services
						//output is HUGE! looks like this:
						//<TIMESTAMP>: ALCXWDM:Service for Realtek AC97 Audio (WDM)
						//	*** The service is a device driver.
						//	*** The service is running.
						//	*** -
						for(DWORD i = 0; i < dwFoundServiceCount; i++)
						{
							ENUM_SERVICE_STATUS_PROCESS* pCurrent = (ENUM_SERVICE_STATUS_PROCESS*)(pBuffer+i*sizeof(ENUM_SERVICE_STATUS_PROCESS));
							theApp.QueueLogLineEx(LOG_WARNING, _T("%s:%s\n*** %s\n*** %s\n*** %s"), 
								pCurrent->lpServiceName, 
								pCurrent->lpDisplayName,
								_DbgServiceType(pCurrent->ServiceStatusProcess.dwServiceType),
								_DbgServiceStatus(pCurrent->ServiceStatusProcess.dwCurrentState),
								_DbgSystemService(pCurrent->ServiceStatusProcess.dwServiceFlags));
						}
					}
					else
						theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: error while enumerating! (%s)"), _DbgServiceError(::GetLastError()));
					delete[] pBuffer;
					pBuffer = NULL;
				}
				//this while is a bit critical... will dwNeededBytes be correct!?
				//do we have to check for ERROR_MORE_DATA or is it sufficient to check the variable?! 
				//have to find out... otherwise we are in a deadlock here :-| 
				while(dwNeededBytes != 0); 
				theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: ...enum complete!"));
			}
			else
			{
				theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: error while enumerating! (%s)"), _DbgServiceError(::GetLastError()));
				theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: failed to get buffersize"));
			}
#endif
			//////////////////////////////////////////////////////////////////////////
			//this opens a service and starts it if necessary
			SC_HANDLE schService = OpenService( 
				schSCManager,				// SCM database 
				SERVICE_NAME,				// service name
				SERVICE_QUERY_CONFIG|SERVICE_QUERY_STATUS); 

			if (schService) 
			{		
				SERVICE_STATUS status;
				if(QueryServiceStatus(schService, &status))
				{
					//critical - can we expect it to be running?
					CString msg = _T("UPnP system service is not running - do you want to start it?");
					m_bUPnPWasRunning = status.dwCurrentState == SERVICE_RUNNING;
					if(status.dwCurrentState != SERVICE_RUNNING 
						//if we can't ask the user, fail it...
						&& (bSkipMessageBoxes
						|| (bAllowMessageBox && AfxMessageBox(msg, MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON1) == IDYES)))
					{
						//now we should start it, however, we have to check the 
						//config first, it might be disabled...
						DWORD dwNeededBytes = 0;
						QueryServiceConfig(schService, NULL, 0, &dwNeededBytes);
						const DWORD buffsize = dwNeededBytes;
						LPQUERY_SERVICE_CONFIG pBuffer = (LPQUERY_SERVICE_CONFIG)new BYTE[buffsize];	
						if(QueryServiceConfig(schService, pBuffer, buffsize, &dwNeededBytes))
						{
							 QUERY_SERVICE_CONFIG* config = (QUERY_SERVICE_CONFIG*)pBuffer;
							 CString msg = _T("UPnP system service is disabled - do you want to set it to start on demand?");
							 m_dwUPnPWasServiceState = config->dwStartType;
							 if(config->dwStartType == SERVICE_DISABLED 
								 //if we can't ask the user, fail it...
								 && (bSkipMessageBoxes
								 || (/*bAllowMessageBox &&*/ AfxMessageBox(msg, MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON1) == IDYES)))
							 {
								 //possible TODO!
								 //1) do we have to reopen the manager with more rights?
								 //2) do we have to close the service/manager handle prior to reopening?
								 //we have to open the service with more rights!
								 SC_HANDLE schChangeService = OpenService( 
									 schSCManager,		
									 SERVICE_NAME,		
									 SERVICE_CHANGE_CONFIG); 

								 if (schChangeService && ChangeServiceConfig(schChangeService, SERVICE_NO_CHANGE, SERVICE_DEMAND_START, SERVICE_NO_CHANGE, NULL, NULL, NULL, NULL, NULL, NULL, NULL))
								 {
									 theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: Changed service config to start on demand!"));
									 CloseServiceHandle(schChangeService);
								 }
								 else
									 theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not change service config - Error %s!"), _DbgServiceError(::GetLastError()));
							 }
						}
						else
							theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not query service config - Error %s!"), _DbgServiceError(::GetLastError()));
						delete[] pBuffer;
						pBuffer = NULL;
						CloseServiceHandle(schService); 

						StartUPnPService(&schSCManager, &status);

						if (status.dwCurrentState == SERVICE_RUNNING) 
						{
							strNotPossible = _T("");
							theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: Successfully started service!"));
						}
						else 
							theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: FAILED to start service! State: %u, Exit code: %u, Wait: %ums"),
								status.dwCurrentState, status.dwWin32ExitCode, status.dwWaitHint);
//<<< MSDN
					}
					else
						strNotPossible = _T(""); //should be running
				}
				else
					theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not query service status - Error %s!"), _DbgServiceError(::GetLastError()));

				CloseServiceHandle(schService); 
			} 
			else
				theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not open service - Error %s!"), _DbgServiceError(::GetLastError()));

			CloseServiceHandle(schSCManager);
		}
		else
			theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not open services database - Error %s!"), GetErrorMessage(::GetLastError()));
	}
	else
		strNotPossible = _T("wrong windows version");
	if(!strNotPossible.IsEmpty())
	{
		m_bUPnPPossible = false;
		theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: %s, UPnP can't work!"), strNotPossible);
	}
}

void CUPnPNat::StartUPnPService(SC_HANDLE* schSCManager, SERVICE_STATUS* status)
{
	//////////////////////////////////////////////////////////////////////////
	//now that we are here we could try to start it!
	//Note: parts here are taken from the MSDN, though greatly changed!
	SC_HANDLE schStartService = OpenService( 
		*schSCManager,				// SCM database 
		SERVICE_NAME,				// service name
		SERVICE_START|SERVICE_QUERY_STATUS); 

	if (schStartService) 
	{		
		if (StartService(schStartService,								
			0,           // number of arguments 
			NULL))      // no arguments 
		{
			// Check the status until the service is no longer start pending. 								
			if(QueryServiceStatus(schStartService, status))
			{
				// Save the tick count and initial checkpoint.
				DWORD dwStartTickCount = ::GetTickCount();
				DWORD dwOldCheckPoint = status->dwCheckPoint;
				while (status->dwCurrentState == SERVICE_START_PENDING) 
				{ 
					// Do not wait longer than the wait hint. A good interval is 
					// one tenth the wait hint, but no less than 1 second and no 
					// more than 10 seconds. 
					DWORD dwWaitTime = status->dwWaitHint / 10;
					if(dwWaitTime < 1000)
						dwWaitTime = 1000;
					else if (dwWaitTime > 10000)
						dwWaitTime = 10000;
					Sleep(dwWaitTime);

					// Check the status again. 
					if(QueryServiceStatus(schStartService, status))
					{
						/*
						dwWaitHint 
						Estimated time required for a pending start, stop, pause, or continue operation, in milliseconds. Before the 
						specified amount of time has elapsed, the service should make its next call to the SetServiceStatus function with either an 
						incremented dwCheckPoint value or a change in dwCurrentState. If the amount of time specified by dwWaitHint 
						passes, and dwCheckPoint has not been incremented or dwCurrentState has not changed, the service control 
						manager or service control program can assume that an error has occurred and the service should be stopped
						*/
						if (status->dwCheckPoint > dwOldCheckPoint)
						{
							// The service is making progress.
							dwStartTickCount = ::GetTickCount();
							dwOldCheckPoint = status->dwCheckPoint;
						}
						else
						{
							// No progress made within the wait hint
							if(::GetTickCount()-dwStartTickCount > status->dwWaitHint)
								break;												
						}
					}
					else
					{
						theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not update query service status - Error %s!"), _DbgServiceError(::GetLastError()));
						break;
					}
				} 
			}
			else
				theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not query service status - Error %s!"), _DbgServiceError(::GetLastError()));
		}
		else
			theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not start service - Error %s!"), _DbgServiceError(::GetLastError()));
		CloseServiceHandle(schStartService); 
	}
	else
		theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not open service - Error %s!"), _DbgServiceError(::GetLastError()));
}

void CUPnPNat::StopUPnPService()
{
	if(!m_bUPnPWasRunning && m_dwUPnPWasServiceState == SERVICE_STATE_UNDEFINED)
		return;

	//do not add loglines in case the app is just shutting down
	//this will result in a minor memleak because messages won't be printed
	//nor deleted
	const bool bLog = theApp.m_app_state == APP_STATE_RUNNING;

	// Open a handle to the SC Manager database. 
	SC_HANDLE schSCManager = OpenSCManager( 
		NULL,						// local machine 
		SERVICES_ACTIVE_DATABASE,	// ServicesActive database 
		SC_MANAGER_ENUMERATE_SERVICE);

	if (!schSCManager) 
	{
		if(bLog)
			theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not open services database - Error %s!"), GetErrorMessage(::GetLastError()));
		return;
	}

	SERVICE_STATUS status;
	memset(&status, 0, sizeof(SERVICE_STATUS));
	status.dwCurrentState = SERVICE_RUNNING;
	SC_HANDLE schStopService = OpenService( 
		schSCManager,				// SCM database 
		SERVICE_NAME,				// service name
		SERVICE_STOP|SERVICE_QUERY_STATUS|SERVICE_QUERY_CONFIG); 

	if(!m_bUPnPWasRunning)
	{
		if (schStopService) 
		{		
			if (ControlService(schStopService,								
				SERVICE_CONTROL_STOP,
				&status))
			{
				// Check the status until the service is no longer start pending. 								
				if(QueryServiceStatus(schStopService, &status))
				{
					// Save the tick count and initial checkpoint.
					DWORD dwStopTickCount = ::GetTickCount();
					DWORD dwOldCheckPoint = status.dwCheckPoint;
					while (status.dwCurrentState == SERVICE_STOP_PENDING) 
					{ 
						// Do not wait longer than the wait hint. A good interval is 
						// one tenth the wait hint, but no less than 1 second and no 
						// more than 10 seconds. 
						DWORD dwWaitTime = status.dwWaitHint / 10;
						if(dwWaitTime < 1000)
							dwWaitTime = 1000;
						else if (dwWaitTime > 10000)
							dwWaitTime = 10000;
						Sleep(dwWaitTime);

						// Check the status again. 
						if(QueryServiceStatus(schStopService, &status))
						{
							/*
							dwWaitHint 
							Estimated time required for a pending start, stop, pause, or continue operation, in milliseconds. Before the 
							specified amount of time has elapsed, the service should make its next call to the SetServiceStatus function with either an 
							incremented dwCheckPoint value or a change in dwCurrentState. If the amount of time specified by dwWaitHint 
							passes, and dwCheckPoint has not been incremented or dwCurrentState has not changed, the service control 
							manager or service control program can assume that an error has occurred and the service should be stopped
							*/
							if (status.dwCheckPoint > dwOldCheckPoint)
							{
								// The service is making progress.
								dwStopTickCount = ::GetTickCount();
								dwOldCheckPoint = status.dwCheckPoint;
							}
							else
							{
								// No progress made within the wait hint
								if(::GetTickCount()-dwStopTickCount > status.dwWaitHint)
									break;												
							}
						}
						else
						{
							if(bLog)
								theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not update query service status - Error %s!"), _DbgServiceError(::GetLastError()));
							break;
						}
					} 
				}
				else if(bLog)
					theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not query service status - Error %s!"), _DbgServiceError(::GetLastError()));
			}
			else if(bLog)
				theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not stop service - Error %s!"), _DbgServiceError(::GetLastError()));
		}
		else if(bLog)
			theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not open service - Error %s!"), _DbgServiceError(::GetLastError()));
		if (status.dwCurrentState == SERVICE_STOPPED) 
		{
			if(bLog)
				theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: Successfully stopped service!"));
		}
		else 
		{
			if(bLog)
				theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: FAILED to stop service! State: %u, Exit code: %u, Wait: %ums"),
					status.dwCurrentState, status.dwWin32ExitCode, status.dwWaitHint);
		}
	}
	if(m_dwUPnPWasServiceState != SERVICE_STATE_UNDEFINED)
	{
		//config first, it might be disabled...
		DWORD dwNeededBytes = 0;
		QueryServiceConfig(schStopService, NULL, 0, &dwNeededBytes);
		const DWORD buffsize = dwNeededBytes;
		LPQUERY_SERVICE_CONFIG pBuffer = (LPQUERY_SERVICE_CONFIG)new BYTE[buffsize];	
		if(QueryServiceConfig(schStopService, pBuffer, buffsize, &dwNeededBytes))
		{
			QUERY_SERVICE_CONFIG* config = (QUERY_SERVICE_CONFIG*)pBuffer;
			if(config->dwStartType != m_dwUPnPWasServiceState)				
			{
				//possible TODO!
				//1) do we have to reopen the manager with more rights?
				//2) do we have to close the service/manager handle prior to reopening?
				//we have to open the service with more rights!
				SC_HANDLE schChangeService = OpenService( 
					schSCManager,		
					SERVICE_NAME,		
					SERVICE_CHANGE_CONFIG); 

				if (schChangeService && ChangeServiceConfig(schChangeService, SERVICE_NO_CHANGE, m_dwUPnPWasServiceState, SERVICE_NO_CHANGE, NULL, NULL, NULL, NULL, NULL, NULL, NULL))
				{
					if(bLog)
						theApp.QueueLogLineEx(LOG_SUCCESS, _T("UPnP: Changed service config back to default!"));
					CloseServiceHandle(schChangeService);
				}
				else if(bLog)
					theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not change service config - Error %s!"), _DbgServiceError(::GetLastError()));
			}
		}
		else if(bLog)
			theApp.QueueLogLineEx(LOG_ERROR, _T("UPnP: Could not query service config - Error %s!"), _DbgServiceError(::GetLastError()));
		delete[] pBuffer;
		pBuffer = NULL;		
	}
	CloseServiceHandle(schStopService); 
	CloseServiceHandle(schSCManager);
}
//<<< WiZaRd::UPnP

CUPnPNat::CUPnPNat(void)
{
	m_uLocalIP = 0;
//>>> WiZaRd::UPnP
	m_bUPnPPossible = true; 
	m_bUPnPWasRunning = false;
	m_dwUPnPWasServiceState = SERVICE_STATE_UNDEFINED;
//<<< WiZaRd::UPnP
}

CUPnPNat::~CUPnPNat(void)
{	
	POSITION pos = m_Mappings.GetHeadPosition();
	while(pos)
		RemoveNATPortMapping(m_Mappings.GetNext(pos), false);
	m_Mappings.RemoveAll();
	StopUPnPService(); //>>> WiZaRd::UPnP
}

/////////////////////////////////////////////////////////////////////////////////
// Adds a NAT Port Mapping
// Params:
//		UPNPNAT_MAPPING *mapping  ->  Port Mapping Data
//			If mapping->externalPort is 0, then
//			mapping->externalPort gets the value of mapping->internalPort
//		bool tryRandom:
//			If If mapping->externalPort is in use, tries to find a free
//			random external port.
//
// Return:
//		UNAT_OK:
//			Successfull.
//		UNAT_EXTERNAL_PORT_IN_USE:
//			Error, you are trying to add a port mapping with an external port
//			in use.
//		UNAT_NOT_IN_LAN:
//			Error, you aren't in a LAN -> no router or firewall
//		UNAT_ERROR:
//			Error, use GetLastError() to get an error description.
/////////////////////////////////////////////////////////////////////////////////
CUPnPNat::UPNPNAT_RETURN CUPnPNat::AddNATPortMapping(UPNPNAT_MAPPING *mapping, bool tryRandom)
{
//>>> WiZaRd::UPnP
	if(!IsUPnPPossible())
	{
		SetLastError(_T("UPnP not available!"));
		return UNAT_ERROR;
	}
//<<< WiZaRd::UPnP
	if(!IsLANIP(GetLocalIP()))
	{
		SetLastError(_T("You aren't behind a Hardware Firewall or Router"));
		return UNAT_NOT_IN_LAN;
	}

	IUPnPNAT *nat = NULL;
	::CoInitialize(NULL);
	HRESULT hResult = ::CoCreateInstance(__uuidof(UPnPNAT), NULL,  CLSCTX_ALL,  __uuidof(IUPnPNAT), (void**)&nat);

	UPNPNAT_RETURN Status = UNAT_ERROR;
	if (hResult == S_OK && nat) 
	{
		IStaticPortMappingCollection *spmc;
		hResult = nat->get_StaticPortMappingCollection(&spmc);
		if (hResult == S_OK && spmc) 
		{
			CComBSTR Proto;
			CString	ProtoStr;

			if (mapping->protocol == UNAT_TCP)
			{
				Proto = _T("TCP");
				ProtoStr = _T("TCP");
			}
			else 
			{
				Proto = _T("UDP");
				ProtoStr = _T("UDP");
			}

			if(mapping->externalPort == 0)
				mapping->externalPort = mapping->internalPort;
			int retries = 255;
			BOOL portUsed = FALSE;
			WORD rndPort = mapping->externalPort;
			IStaticPortMapping *spm = NULL;
			do 
			{				
				hResult = spmc->get_Item(rndPort, Proto, &spm);
				portUsed = spm != NULL;
				if (hResult == S_OK && spm) 
				{
					// External port in use
					spm->Release();
					if (tryRandom)
					{
						retries--;
						if (retries == 0) 
						{
							// Too many retries
							spmc->Release();
							nat->Release();
							SetLastError(_T("External NAT port in use: Too many retries"));
							return UNAT_EXTERNAL_PORT_IN_USE;
						}
						rndPort = 2049 + WORD(((float)rand() / RAND_MAX) * (65535 - 2049));
					}
					else
					{
						spmc->Release();
						nat->Release();
						SetLastError(_T("External NAT port in use"));
						::CoUninitialize();
						return UNAT_EXTERNAL_PORT_IN_USE;
					}
				}
			} 
			while (portUsed);

			mapping->externalPort = rndPort;

			CString Desc;
			Desc.Format(_T("eMule (%s) [%s: %u]"), mapping->description, ProtoStr, mapping->externalPort);

			CComBSTR DescBSTR(Desc);
			hResult = spmc->Add(mapping->externalPort, Proto, mapping->internalPort, GetLocalIPBSTR(), TRUE, DescBSTR, &spm);
			if (hResult == S_OK && spm) 
			{
				/* Add new NAT port mapping */
				spm->Release();
				Status = UNAT_OK;
				
				m_Mappings.AddTail(*mapping);
			}
			spmc->Release();
		}
		else
		{
			if (hResult == S_OK) //spmc == NULL
				SetLastError(_T("Error getting StaticPortMappingCollection"));
			else
				SetLastIUPnPNATError(hResult, _T("Unknown error (2)"));
		}
		nat->Release();
	}
	else 
	{
		if (hResult == S_OK) //nat == NULL
			SetLastError(_T("Error getting IUPnPNAT"));
		else
			SetLastClassError(hResult, _T("Unknown error (1)"));
	}

	::CoUninitialize();
	return Status;
}

/////////////////////////////////////////////////////////////////////////////////
// Removes a NAT Port Mapping
// Params:
//		UPNPNAT_MAPPING *mapping  ->  Port Mapping Data
//			Should be the same struct passed to AddNATPortMapping
//		bool removeFromList	-> Remove the port mapping from the internal list
//			Should by allways true (dafault value if not passed).
//			If you set it to false can cause an unexpected error.
//
//
// Return:
//		UNAT_OK:
//			Successfull.
//		UNAT_NOT_OWNED_PORTMAPPING:
//			Error, you are trying to remove a port mapping not owned by this class
//		UNAT_NOT_IN_LAN:
//			Error, you aren't in a LAN -> no router or firewall
//		UNAT_ERROR:
//			Error, use GetLastError() to get an error description.
/////////////////////////////////////////////////////////////////////////////////
CUPnPNat::UPNPNAT_RETURN CUPnPNat::RemoveNATPortMapping(UPNPNAT_MAPPING mapping, bool removeFromList)
{
//>>> WiZaRd::UPnP
	if(!IsUPnPPossible())
	{
		SetLastError(_T("UPnP not available!"));
		return UNAT_ERROR;
	}
//<<< WiZaRd::UPnP
	if(!IsLANIP(GetLocalIP()))
	{
		SetLastError(_T("You aren't behind a Hardware Firewall or Router"));
		return UNAT_NOT_IN_LAN;
	}

	UPNPNAT_RETURN Status = UNAT_ERROR;
	bool found = false;	
	
	for(POSITION pos = m_Mappings.GetHeadPosition(); !found && pos!=NULL; m_Mappings.GetNext(pos))
	{
		const UPNPNAT_MAPPING* search = &m_Mappings.GetAt(pos);
		
		if (search->externalPort == mapping.externalPort 
			&& search->protocol == mapping.protocol)
		{
			found = true;
			::CoInitialize(NULL);
			IUPnPNAT *nat = NULL;
   			HRESULT hResult = ::CoCreateInstance(__uuidof(UPnPNAT), NULL,  CLSCTX_ALL,  __uuidof(IUPnPNAT), (void**)&nat);
		
			CComBSTR Proto;
			if (mapping.protocol == UNAT_TCP)
				Proto = _T("TCP");
			else
				Proto = _T("UDP");

			if (hResult == S_OK && nat) 
			{
				IStaticPortMappingCollection *spmc = NULL;
				hResult = nat->get_StaticPortMappingCollection(&spmc);
				if (hResult == S_OK && spmc) 
				{
					spmc->Remove(mapping.externalPort, Proto);
					spmc->Release();
					Status = UNAT_OK;

					if(removeFromList)
						m_Mappings.RemoveAt(pos);
				}
				else 
				{
					if (hResult == S_OK) //spmc == NULL
						SetLastError(_T("Error getting StaticPortMappingCollection"));
					else
						SetLastIUPnPNATError(hResult, _T("Unknown error (5)"));
				}
				nat->Release();
			}
			else 
			{
				if (hResult == S_OK) //nat == NULL
					SetLastError(_T("Error getting IUPnPNAT"));
				else
					SetLastClassError(hResult, _T("Unknown error (4)"));
			}
			::CoUninitialize();
		}
	}
	
	if(!found)
	{
		SetLastError(_T("Port mapping not owned by this class"));
		return UNAT_NOT_OWNED_PORTMAPPING;
	}
	return Status;
}

/////////////////////////////////////////////////////////////////////////////////
// Initializes m_localIP variable, for future access to GetLocalIP()
/////////////////////////////////////////////////////////////////////////////////
void CUPnPNat::InitLocalIP()
{
	try
	{
		char szHost[256];
		if (gethostname(szHost, sizeof szHost) == 0)
		{
			hostent* pHostEnt = gethostbyname(szHost);
			if (pHostEnt != NULL && pHostEnt->h_length == 4 && pHostEnt->h_addr_list[0] != NULL)
			{
				CUPnPNat::UPNPNAT_MAPPING mapping;
				struct in_addr addr;

				memcpy(&addr, pHostEnt->h_addr_list[0], sizeof(struct in_addr));
				m_slocalIP = inet_ntoa(addr);
				m_uLocalIP = addr.S_un.S_addr;
			}
			else
				throw;
		}
		else
			throw;
	}
	catch(...)
	{
		m_slocalIP = _T("");
		m_uLocalIP = 0;
	}	
}

/////////////////////////////////////////////////////////////////////////////////
// Returns the Local IP
/////////////////////////////////////////////////////////////////////////////////
DWORD CUPnPNat::GetLocalIP()
{
	if(m_uLocalIP == 0)
		InitLocalIP();
	
	return m_uLocalIP;
}

/////////////////////////////////////////////////////////////////////////////////
// Returns a CString with the local IP in format xxx.xxx.xxx.xxx
/////////////////////////////////////////////////////////////////////////////////
CString CUPnPNat::GetLocalIPStr()
{
	if(m_slocalIP.IsEmpty())
		InitLocalIP();
	
	return m_slocalIP;
}

/////////////////////////////////////////////////////////////////////////////////
// Returns a CComBSTR with the local IP in format xxx.xxx.xxx.xxx
/////////////////////////////////////////////////////////////////////////////////
CComBSTR CUPnPNat::GetLocalIPBSTR()	
{
	return CComBSTR(GetLocalIPStr()); 
}

/////////////////////////////////////////////////////////////////////////////////
// Sets the value of m_lastError (last error description)
/////////////////////////////////////////////////////////////////////////////////
void CUPnPNat::SetLastError(CString error)	
{
	m_slastError = error;
}

/////////////////////////////////////////////////////////////////////////////////
// Sets the m_lastError string value if CoCreateInstance() fails
/////////////////////////////////////////////////////////////////////////////////
void CUPnPNat::SetLastClassError(HRESULT result, CString defaultString)
{
	switch (result)
	{
		case REGDB_E_CLASSNOTREG:
			m_slastError = _T("Class not registered in the registration database");
			break;
		case CLASS_E_NOAGGREGATION:
			m_slastError = _T("This class cannot be created as part of an aggregate");
			break;
		case E_NOINTERFACE:
			m_slastError = _T("The specified class does not implement the requested interface");
			break;
		default:
			m_slastError = defaultString;
			break;
	}
}

/////////////////////////////////////////////////////////////////////////////////
// Sets the m_lastError string value if an IUPnPNAT object fails
/////////////////////////////////////////////////////////////////////////////////
void CUPnPNat::SetLastIUPnPNATError(HRESULT result, CString defaultString)
{
	switch(result)
	{
		case E_ABORT:
			m_slastError = _T("The operation was aborted");
			break;
		case E_FAIL:
			m_slastError = _T("An unspecified error occurred");
			break;
		case E_INVALIDARG:
			m_slastError = _T("One of the parameters is invalid");
			break;
		case E_NOINTERFACE:
			m_slastError = _T("A specified interface is not supported");
			break;
		case E_NOTIMPL: 
			m_slastError = _T("A specified method is not implemented");
			break;
		case E_OUTOFMEMORY:
			m_slastError = _T("The method was unable to allocate required memory");
			break;
		case E_POINTER:
			m_slastError = _T("A pointer passed as a parameter is not valid");
			break;
		case E_UNEXPECTED:
			m_slastError = _T("The method failed for unknown reasons");
			break;
		default:
			m_slastError = defaultString;
			break;
	}
}

/////////////////////////////////////////////////////////////////////////////////
// Returns the last error description in a CString
/////////////////////////////////////////////////////////////////////////////////
CString CUPnPNat::GetLastError()
{ 
	return m_slastError; 
}

/////////////////////////////////////////////////////////////////////////////////
// Returns true if nIP is a LAN ip, false otherwise
/////////////////////////////////////////////////////////////////////////////////
bool CUPnPNat::IsLANIP(DWORD nIP)
{
	// filter LAN IP's
	// -------------------------------------------
	// 0.*
	// 10.0.0.0 - 10.255.255.255  class A
	// 172.16.0.0 - 172.31.255.255  class B
	// 192.168.0.0 - 192.168.255.255 class C

	uchar nFirst = (uchar)nIP;
	uchar nSecond = (uchar)(nIP >> 8);

	if (nFirst==192 && nSecond==168) // check this 1st, because those LANs IPs are mostly spreaded
		return true;

	if (nFirst==172 && nSecond>=16 && nSecond<=31)
		return true;

	if (nFirst==0 || nFirst==10)
		return true;

	return false; 
}